CREATE TABLE #RSPAGAR (CD_EMP INT, 
					   CD_FILIAL INT, 
					   CD_PG_CRED INT, 
					   NR_TIT VARCHAR(100))

INSERT INTO #RSPAGAR
SELECT
	PG_CRED.CD_EMP,
	PG_CRED.CD_FILIAL,
	PG_CRED.CD_PG_CRED,
	PG_CRED.NR_TIT + ' - ' + CONVERT(VARCHAR(10),ROW_NUMBER() OVER (ORDER BY PG_CRED.NR_TIT)) AS CTR
FROM
PG_CRED INNER JOIN 

(SELECT	
    CD_FORN,
	NR_TIT,
	CD_FILIAL,
	CD_EMP
FROM
	PG_CRED
GROUP BY
	CD_FORN,
	NR_TIT,
	CD_FILIAL,
	CD_EMP
HAVING
	COUNT(*)>1) RS ON
PG_CRED.NR_TIT = RS.NR_TIT AND
PG_CRED.CD_EMP = RS.CD_EMP AND
PG_CRED.CD_FILIAL = RS.CD_FILIAL

UPDATE
	C
SET 
	C.NR_TIT = P.NR_TIT
FROM
	PG_CRED C INNER JOIN #RSPAGAR P ON
	C.CD_EMP = P.CD_EMP AND
	C.CD_FILIAL = P.CD_FILIAL AND
	C.CD_PG_CRED = P.CD_PG_CRED

DROP TABLE #RSPAGAR
GO
GO
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PG_CRED]') 
		  AND name = N'IX_PG_CRED_NUMERO_TITULO')
begin 
    	ALTER TABLE [dbo].[PG_CRED] DROP CONSTRAINT [IX_PG_CRED_NUMERO_TITULO] 

END
GO
	ALTER TABLE [dbo].[PG_CRED] ADD CONSTRAINT [IX_PG_CRED_NUMERO_TITULO] UNIQUE NONCLUSTERED 
	(
		[TP_DP]	    ASC,
		[NR_TIT]	    ASC,
		[CD_FILIAL]   ASC,
		[CD_EMP]	    ASC,
		[CD_FORN]	    ASC

	)  WITH (PAD_INDEX = OFF, 
			 STATISTICS_NORECOMPUTE = OFF, 
			 SORT_IN_TEMPDB = OFF, 
			 IGNORE_DUP_KEY = OFF, 
			 ONLINE = OFF, 
			 ALLOW_ROW_LOCKS = ON, 
			 ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
